function [x,y] = coordinates_round_snowflake(x_cen, y_cen, r, w, rad_curv, rad_curv2, resolution)

% x_cen = 0;
% y_cen = 0;
% r = 180e-9;
% w = 75e-9;
% rad_curv = 20e-9;
% rad_curv2 = 10e-9;
% resolution = 10;

x_ini = [];
y_ini = [];

res = 60;

temp_x = x_cen+w/2*sqrt(3)+rad_curv2*sqrt(3)+rad_curv2*cos(210*pi/180);
temp_y = y_cen-w/2-rad_curv2+rad_curv2*sin(210*pi/180);
[temp_x, temp_y] = rotate(temp_x, temp_y, x_cen, y_cen, 60);

x_ini = linspace(temp_x, x_cen+r-rad_curv, res);
y_ini = linspace(temp_y, y_cen+w/2, res);

angle = linspace(90, 0, resolution);
temp_x = x_cen+r-rad_curv+rad_curv*cos(angle*pi/180);
temp_y = y_cen+w/2-rad_curv+rad_curv*sin(angle*pi/180);

temp1_x = linspace(temp_x(end), x_cen+r, res);
temp1_y = linspace(temp_y(end), y_cen-w/2+rad_curv, res);
x_ini = [x_ini temp_x(2:end) temp1_x(2:end)];
y_ini = [y_ini temp_y(2:end) temp1_y(2:end)];

angle = linspace(360, 270, resolution);
temp_x = x_cen+r-rad_curv+rad_curv*cos(angle*pi/180);
temp_y = y_cen-w/2+rad_curv+rad_curv*sin(angle*pi/180);

temp1_x = linspace(temp_x(end), x_cen+w/2*sqrt(3)+rad_curv2*sqrt(3), res);
temp1_y = linspace(temp_y(end), y_cen-w/2, res);
x_ini = [x_ini temp_x(2:end) temp1_x(2:end)];
y_ini = [y_ini temp_y(2:end) temp1_y(2:end)];

angle = linspace(90, 210, resolution);
temp_x = x_cen+w/2*sqrt(3)+rad_curv2*sqrt(3)+rad_curv2*cos(angle*pi/180);
temp_y = y_cen-w/2-rad_curv2+rad_curv2*sin(angle*pi/180);

x_ini = [x_ini temp_x(2:end)];
y_ini = [y_ini temp_y(2:end)];

angle = -60;

[x_rot1, y_rot1] = rotate(x_ini, y_ini, x_cen, y_cen, angle);
[x_rot2, y_rot2] = rotate(x_ini, y_ini, x_cen, y_cen, 2*angle);
[x_rot3, y_rot3] = rotate(x_ini, y_ini, x_cen, y_cen, 3*angle);
[x_rot4, y_rot4] = rotate(x_ini, y_ini, x_cen, y_cen, 4*angle);
[x_rot5, y_rot5] = rotate(x_ini, y_ini, x_cen, y_cen, 5*angle);

x = horzcat(x_ini, x_rot1, x_rot2, x_rot3, x_rot4, x_rot5, x_ini(1));
y = horzcat(y_ini, y_rot1, y_rot2, y_rot3, y_rot4, y_rot5, y_ini(1));

% plot(x, y, '.', 'color', 'red', 'LineWidth', 0.5)
% 
% plot(x_ini, y_ini, '.', 'color', 'black', 'LineWidth', 0.5)

end